/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobFletcher;
import java.util.Optional;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFletcher
extends AbstractBuildingWorker
implements IBuildingPublicCrafter {
    private static final String FLETCHER = "fletcher";

    public BuildingFletcher(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FLETCHER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobFletcher(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return FLETCHER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Dexterity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Creativity;
    }

    @Override
    @NotNull
    public Skill getCraftSpeedSkill() {
        return this.getPrimarySkill();
    }

    @Override
    @NotNull
    public Skill getRecipeImprovementSkill() {
        return this.getSecondarySkill();
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.fletcher;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobFletcher(null));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingFletcher.FLETCHER);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            Item output = recipe.getPrimaryOutput().func_77973_b();
            return output instanceof ArrowItem || output instanceof DyeableArmorItem && ((DyeableArmorItem)output).func_200880_d() == ArmorMaterial.LEATHER;
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingFletcher.FLETCHER);
        }
    }
}

